package fr.asip.cps3.exemple.modele.resultats;

import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe reprsentant le rsultat de 2 oprations sucessives accompagn d'informations
 */
public class ResultatDoubleInfo extends ResultatInfo {

	/**
	 * Deuxime code retour PKCS#11 
	 */
	protected long codeRetour2;

	/**
	 * Description de la deuxime opration  l'origine du rsultat
	 */
	protected String operation2;
	
	/**
	 * Constructeur
	 * @param operation1 Description de la premire opration
	 * @param operation2 Description de la deuxime opration
	 */
	public ResultatDoubleInfo(String operation1, String operation2){
		super(operation1);
		this.codeRetour2 = 0L;
		this.operation2 = operation2;
	}

	/**
	 * Accesseur
	 * @return La description de la deuxime opration  l'origine du rsultat
	 */
	public String getOperation2() {
		return operation2;
	}

	/**
	 * Ajoute du texte  la description de la deuxime opration
	 * @param texte Texte  ajouter  la description de la deuxime opration
	 */
	public void appendOperation2(String texte) {
		this.operation2 += texte;
	}
	
	/**
	 * Accesseur
	 * @return codeRetour2 Deuxime code retour PKCS#11
	 */
	public String getCodeRetour2() {
		return TraitementsUtil.retranscritCodeRetour(codeRetour2);
	}

	/**
	 * Mutateur
	 * @param codeRetour2 Deuxime code retour PKCS#11
	 */
	public void setCodeRetour2(long codeRetour2) {
		this.codeRetour2 = codeRetour2;
	}
	
}
